/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.Fetch;
import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.PyCursor;
import com.ziclix.python.sql.zxJDBC;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyUnicode;
import org.python.core.codecs;

public class PyStatement
extends PyObject {
    public static final int STATEMENT_STATIC = 2;
    public static final int STATEMENT_PREPARED = 4;
    public static final int STATEMENT_CALLABLE = 8;
    private int style;
    private Object sql;
    private boolean closed;
    Statement statement;
    protected static PyList __methods__;
    protected static PyList __members__;

    public PyStatement(Statement statement, Object object, int n) {
        this.statement = statement;
        this.sql = object;
        this.style = n;
        this.closed = false;
    }

    public PyStatement(Statement statement, Procedure procedure) {
        this(statement, procedure, 8);
    }

    public PyUnicode __unicode__() {
        if (this.sql instanceof String) {
            return Py.newUnicode((String)this.sql);
        }
        if (this.sql instanceof Procedure) {
            try {
                return Py.newUnicode(((Procedure)this.sql).toSql());
            }
            catch (SQLException sQLException) {
                throw zxJDBC.makeException(sQLException);
            }
        }
        return super.__unicode__();
    }

    public PyString __str__() {
        return Py.newString(this.__unicode__().encode(codecs.getDefaultEncoding(), "replace"));
    }

    public String toString() {
        return String.format("<PyStatement object at %s for [%s]", Py.idstr(this), this.__unicode__());
    }

    public PyObject __findattr_ex__(String string) {
        if ("style".equals(string)) {
            return Py.newInteger(this.style);
        }
        if ("closed".equals(string)) {
            return Py.newBoolean(this.closed);
        }
        if ("__statement__".equals(string)) {
            return Py.java2py(this.statement);
        }
        if ("__methods__".equals(string)) {
            return __methods__;
        }
        if ("__members__".equals(string)) {
            return __members__;
        }
        return super.__findattr_ex__(string);
    }

    public static void classDictInit(PyObject pyObject) {
        PyObject pyObject2 = Py.newString("$Revision: 6694 $").__getslice__(Py.newInteger(11), Py.newInteger(-2));
        pyObject.__setitem__("__version__", pyObject2);
        pyObject.__setitem__("classDictInit", null);
        pyObject.__setitem__("statement", null);
        pyObject.__setitem__("execute", null);
        pyObject.__setitem__("prepare", null);
        pyObject.__setitem__("STATEMENT_STATIC", null);
        pyObject.__setitem__("STATEMENT_PREPARED", null);
        pyObject.__setitem__("STATEMENT_CALLABLE", null);
    }

    public void __del__() {
        this.close();
    }

    public void execute(PyCursor pyCursor, PyObject pyObject, PyObject pyObject2) throws SQLException {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "statement is closed");
        }
        this.prepare(pyCursor, pyObject, pyObject2);
        Fetch fetch = pyCursor.fetch;
        switch (this.style) {
            case 2: {
                if (!this.statement.execute((String)this.sql)) break;
                fetch.add(this.statement.getResultSet());
                break;
            }
            case 4: {
                PreparedStatement preparedStatement = (PreparedStatement)this.statement;
                if (!preparedStatement.execute()) break;
                fetch.add(preparedStatement.getResultSet());
                break;
            }
            case 8: {
                CallableStatement callableStatement = (CallableStatement)this.statement;
                if (callableStatement.execute()) {
                    fetch.add(callableStatement.getResultSet());
                }
                fetch.add(callableStatement, (Procedure)this.sql, pyObject);
                break;
            }
            default: {
                throw zxJDBC.makeException(zxJDBC.ProgrammingError, zxJDBC.getString("invalidStyle"));
            }
        }
    }

    private void prepare(PyCursor pyCursor, PyObject pyObject, PyObject pyObject2) throws SQLException {
        Procedure procedure;
        if (pyObject == Py.None || this.style == 2) {
            return;
        }
        DataHandler dataHandler = pyCursor.datahandler;
        int n = 0;
        int n2 = 0;
        int n3 = pyObject.__len__();
        PreparedStatement preparedStatement = (PreparedStatement)this.statement;
        Procedure procedure2 = procedure = this.style == 8 ? (Procedure)this.sql : null;
        if (this.style != 8) {
            n = pyObject.__len__();
            preparedStatement.clearParameters();
        } else {
            int n4 = n = procedure.columns == Py.None ? 0 : procedure.columns.__len__();
        }
        while (n-- > 0) {
            PyObject pyObject3;
            n2 = n + 1;
            if (procedure != null && !procedure.isInput(n2)) continue;
            PyObject pyObject4 = pyObject.__getitem__(--n3);
            if (pyObject2 != Py.None && (pyObject3 = pyObject2.__finditem__(Py.newInteger(n3))) != null) {
                try {
                    int n5 = pyObject3.asInt();
                    dataHandler.setJDBCObject(preparedStatement, n2, pyObject4, n5);
                    continue;
                }
                catch (PyException pyException) {
                    throw zxJDBC.makeException(zxJDBC.ProgrammingError, zxJDBC.getString("bindingValue"));
                }
            }
            dataHandler.setJDBCObject(preparedStatement, n2, pyObject4);
        }
    }

    public void close() {
        try {
            this.statement.close();
        }
        catch (SQLException sQLException) {
            throw zxJDBC.makeException(sQLException);
        }
        finally {
            this.closed = true;
        }
    }

    static {
        PyObject[] pyObjectArray = new PyObject[]{new PyString("close")};
        __methods__ = new PyList(pyObjectArray);
        pyObjectArray = new PyObject[]{new PyString("style"), new PyString("closed"), new PyString("__statement__")};
        __members__ = new PyList(pyObjectArray);
    }
}

